/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.tools.MapManager;
import net.ftb.util.SwingUtils;

public class MapOverwriteDialog
extends JDialog {
    private JLabel messageLbl;
    private JLabel overwriteLbl;
    private JButton overwrite;
    private JButton abort;

    public MapOverwriteDialog() {
        super((Frame)LaunchFrame.getInstance(), true);
        this.setupGui();
        this.overwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MapManager.overwrite = true;
                MapOverwriteDialog.this.setVisible(false);
            }
        });
        this.abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MapManager.overwrite = false;
                MapOverwriteDialog.this.setVisible(false);
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle("WARNING!");
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.messageLbl = new JLabel(I18N.getLocaleString("MAPOVERRIDE_FOUNDERROR"));
        this.overwriteLbl = new JLabel(I18N.getLocaleString("MAPOVERRIDE_WISHOVERRIDE"));
        this.overwrite = new JButton(I18N.getLocaleString("MAIN_YES"));
        this.abort = new JButton(I18N.getLocaleString("MAIN_NO"));
        this.messageLbl.setHorizontalAlignment(0);
        this.overwriteLbl.setHorizontalAlignment(0);
        panel.add(this.messageLbl);
        panel.add(this.overwriteLbl);
        panel.add(this.overwrite);
        panel.add(this.abort);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.overwriteLbl, hSpring, "West", (Component)panel);
        Spring columnWidth = Spring.max(Spring.width(this.messageLbl), Spring.width(this.overwriteLbl));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.overwriteLbl, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.overwrite, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.abort, 5, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("North", (Component)this.messageLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.messageLbl), Spring.constant(5));
        layout.putConstraint("North", (Component)this.overwriteLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.overwriteLbl), Spring.constant(10));
        layout.putConstraint("North", (Component)this.overwrite, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.abort, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.height(this.overwrite);
        rowHeight = Spring.max(rowHeight, Spring.height(this.abort));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

